﻿using System.Collections;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using UnityEngine.SceneManagement;

//Preloader is a script attached to our preload scene to set up all our managers and singleton classes for constant global access
public class Preloader : MonoBehaviour
{
    public bool DebugLoadGame = true;   //Debug - load directly into the game?

    public static string ExceptionMessage = string.Empty;

    /// <summary>
    /// Sets up the generation values if we're loading directly into the game
    /// </summary>
    private void SetupGeneration()
    {
        List<LSystem> _LSystems = Resources.LoadAll("L-Systems", typeof(LSystem)).ToList().Cast<LSystem>().ToList();

        int seedInt = Utilities.GetCitySeedIntFromString("qGT1Wadl");

        if (seedInt != -1)
        {
            int index = Utilities.Wrap(seedInt, _LSystems.Count);
            GameController.Instance.LSystem = _LSystems[index];

            GameController.Instance.PerlinOffset = new Vector2Int(Utilities.Wrap(seedInt, ConfigurationManager.Instance.Generation.PerlinOffsetClamp), Utilities.Wrap(seedInt, ConfigurationManager.Instance.Generation.PerlinOffsetClamp));
            GameController.Instance.LSystem.IterationsClamp = Utilities.Wrap(seedInt, _LSystems[index].MaximumIterations - _LSystems[index].MinimumIterations) + _LSystems[index].MinimumIterations;
            GameController.Instance.CityDensity = Utilities.Wrap(seedInt, 100);
            GameController.Instance.CitySeed = seedInt;

            AudioManager.Instance.StopMusic();

            Constants.LoadTask = new SceneLoadTask("GameScene", "LOADING GAME, PLEASE WAIT...");
            SceneManager.LoadScene("LoadingScene");
        }
    }

    public void Awake()
    {
        DontDestroyOnLoad(gameObject);  //Make sure we don't destroy the object as it contains all of our managers

        //Let's try to intialize all of our managers
        if (ConfigurationManager.Instance.Initialize())
        {
            if (ColoursManager.Instance.Initialize())
            {
                if (SettingsManager.Instance.Initialize())
                {
                    if (AudioManager.Instance.Initialize())
                    {
                        if (CarsManager.Instance.Initialize())
                        {
                            if (CarPartsManager.Instance.Initialize())
                            {
                                if (StreetsManager.Instance.Initialize())
                                {
                                    if (BuildingsManager.Instance.Initialize())
                                    {
                                        //We initialized everything successfully, load the correct scene based on the debug flag
                                        if (!DebugLoadGame)
                                        {
                                            SceneManager.LoadScene("MenuScene");
                                            return;
                                        }

                                        else
                                        {
                                            SetupGeneration();
                                            SceneManager.LoadScene("GameScene");
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        
        SceneManager.LoadScene("LoadFailedScene");  //If we got here, we failed with loading something - go to the load failed scene
    }
}
